"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    resource_attribute_list: List,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after PutResourceAttributes returns.    Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to add an IP address, it will then be required to call it with both the IP and MAC addresses to prevent overriding the MAC address.   Note the instructions regarding the special use case of the  ResourceAttributeList  parameter when specifying any "VM" related value.     Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call ListDiscoveredResources.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream. .
        migration_task_name(str): Unique identifier that references the migration task. Do not store personal data in this field. .
        resource_attribute_list(List): Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.  Takes the object array of ResourceAttribute where the Type field is reserved for the following values: IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER where the identifying value can be a string up to 256 characters.     If any "VM" related value is set for a ResourceAttribute object, it is required that VM_MANAGER_ID, as a minimum, is always set. If VM_MANAGER_ID is not set, then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in Application Discovery Service repository. See the Example section below for a use case of specifying "VM" related values.    If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in separate type/value pairs passed to the ResourceAttributeList parameter to maximize the chances of matching.   .
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.resource_attribute.put_multiple(
                ctx,
                progress_update_stream=value,
                migration_task_name=value,
                resource_attribute_list=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.resource_attribute.put_multiple progress_update_stream=value, migration_task_name=value, resource_attribute_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="put_resource_attributes",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "ResourceAttributeList": resource_attribute_list,
            "DryRun": dry_run,
        },
    )
