"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, progress_update_stream_name: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.

    Args:
        progress_update_stream_name(str): The name of the ProgressUpdateStream. Do not store personal data in this field. .
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.progress_update_stream.create(
                ctx, progress_update_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.progress_update_stream.create progress_update_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="create_progress_update_stream",
        op_kwargs={
            "ProgressUpdateStreamName": progress_update_stream_name,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, progress_update_stream_name: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:   The only parameter needed for DeleteProgressUpdateStream is the stream name (same as a CreateProgressUpdateStream call).   The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).   If the stream takes time to be deleted, it might still show up on a ListProgressUpdateStreams call.    CreateProgressUpdateStream, ImportMigrationTask, NotifyMigrationTaskState, and all Associate[*] APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.   Once the stream and all of its resources are deleted, CreateProgressUpdateStream for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).

    Args:
        progress_update_stream_name(str): The name of the ProgressUpdateStream. Do not store personal data in this field. .
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.progress_update_stream.delete(
                ctx, progress_update_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.progress_update_stream.delete progress_update_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="delete_progress_update_stream",
        op_kwargs={
            "ProgressUpdateStreamName": progress_update_stream_name,
            "DryRun": dry_run,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists progress update streams associated with the user account making this call.

    Args:
        next_token(str, optional): If a NextToken was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in NextToken. Defaults to None.
        max_results(int, optional): Filter to limit the maximum number of results to list per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.progress_update_stream.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.progress_update_stream.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="list_progress_update_streams",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
