"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def notify(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    task: Dict,
    update_date_time: str,
    next_update_seconds: int,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:   Migration tools will call the NotifyMigrationTaskState API to share the latest progress and status.    MigrationTaskName is used for addressing updates to the correct target.    ProgressUpdateStream is used for access control and to provide a namespace for each migration tool.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream. .
        migration_task_name(str): Unique identifier that references the migration task. Do not store personal data in this field. .
        task(Dict): Information about the task's progress and status.
        update_date_time(str): The timestamp when the task was gathered.
        next_update_seconds(int): Number of seconds after the UpdateDateTime within which the Migration Hub can expect an update. If Migration Hub does not receive an update within the specified interval, then the migration task will be considered stale.
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.migration_task.state.notify(
                ctx,
                progress_update_stream=value,
                migration_task_name=value,
                task=value,
                update_date_time=value,
                next_update_seconds=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.migration_task.state.notify progress_update_stream=value, migration_task_name=value, task=value, update_date_time=value, next_update_seconds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="notify_migration_task_state",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "Task": task,
            "UpdateDateTime": update_date_time,
            "NextUpdateSeconds": next_update_seconds,
            "DryRun": dry_run,
        },
    )
