"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    discovered_resource: Dict,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a discovered resource ID from Application Discovery Service with a migration task.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream.
        migration_task_name(str): The identifier given to the MigrationTask. Do not store personal data in this field. .
        discovered_resource(Dict): Object representing a Resource.
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.discovered_resource.associate(
                ctx,
                progress_update_stream=value,
                migration_task_name=value,
                discovered_resource=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.discovered_resource.associate progress_update_stream=value, migration_task_name=value, discovered_resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="associate_discovered_resource",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "DiscoveredResource": discovered_resource,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    configuration_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociate an Application Discovery Service discovered resource from a migration task.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream.
        migration_task_name(str): The identifier given to the MigrationTask. Do not store personal data in this field. .
        configuration_id(str): ConfigurationId of the Application Discovery Service resource to be disassociated.
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.discovered_resource.disassociate(
                ctx, progress_update_stream=value, migration_task_name=value, configuration_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.discovered_resource.disassociate progress_update_stream=value, migration_task_name=value, configuration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="disassociate_discovered_resource",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "ConfigurationId": configuration_id,
            "DryRun": dry_run,
        },
    )


async def list_all(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists discovered resources associated with the given MigrationTask.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream.
        migration_task_name(str): The name of the MigrationTask. Do not store personal data in this field. .
        next_token(str, optional): If a NextToken was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in NextToken. Defaults to None.
        max_results(int, optional): The maximum number of results returned per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.discovered_resource.list_all(
                ctx, progress_update_stream=value, migration_task_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.discovered_resource.list_all progress_update_stream=value, migration_task_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="list_discovered_resources",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
