"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    created_artifact: Dict,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:   Migration tools can call the AssociateCreatedArtifact operation to indicate which AWS artifact is associated with a migration task.   The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b.   Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream. .
        migration_task_name(str): Unique identifier that references the migration task. Do not store personal data in this field. .
        created_artifact(Dict): An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.) .
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.created_artifact.associate(
                ctx, progress_update_stream=value, migration_task_name=value, created_artifact=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.created_artifact.associate progress_update_stream=value, migration_task_name=value, created_artifact=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="associate_created_artifact",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "CreatedArtifact": created_artifact,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    created_artifact_name: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:   A migration user can call the DisassociateCreatedArtifacts operation to disassociate a created AWS Artifact from a migration task.   The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b.   Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream. .
        migration_task_name(str): Unique identifier that references the migration task to be disassociated with the artifact. Do not store personal data in this field. .
        created_artifact_name(str): An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance, RDS instance, etc.).
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.created_artifact.disassociate(
                ctx,
                progress_update_stream=value,
                migration_task_name=value,
                created_artifact_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.created_artifact.disassociate progress_update_stream=value, migration_task_name=value, created_artifact_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="disassociate_created_artifact",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "CreatedArtifactName": created_artifact_name,
            "DryRun": dry_run,
        },
    )


async def list_all(
    hub,
    ctx,
    progress_update_stream: str,
    migration_task_name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:   Gets the list of the created artifacts while migration is taking place.   Shows the artifacts created by the migration tool that was associated by the AssociateCreatedArtifact API.    Lists created artifacts in a paginated interface.

    Args:
        progress_update_stream(str): The name of the ProgressUpdateStream. .
        migration_task_name(str): Unique identifier that references the migration task. Do not store personal data in this field. .
        next_token(str, optional): If a NextToken was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in NextToken. Defaults to None.
        max_results(int, optional): Maximum number of results to be returned per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.created_artifact.list_all(
                ctx, progress_update_stream=value, migration_task_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.created_artifact.list_all progress_update_stream=value, migration_task_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="list_created_artifacts",
        op_kwargs={
            "ProgressUpdateStream": progress_update_stream,
            "MigrationTaskName": migration_task_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
