"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the migration status of an application.

    Args:
        application_id(str): The configurationId in Application Discovery Service that uniquely identifies the grouped application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.application_state.describe(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.application_state.describe application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="describe_application_state",
        op_kwargs={"ApplicationId": application_id},
    )


async def list_all(
    hub,
    ctx,
    application_ids: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the migration statuses for your applications. If you use the optional ApplicationIds parameter, only the migration statuses for those applications will be returned.

    Args:
        application_ids(List, optional): The configurationIds from the Application Discovery Service that uniquely identifies your applications. Defaults to None.
        next_token(str, optional): If a NextToken was returned by a previous call, there are more results available. To retrieve the next page of results, make the call again using the returned token in NextToken. Defaults to None.
        max_results(int, optional): Maximum number of results to be returned per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.application_state.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.application_state.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="list_application_states",
        op_kwargs={
            "ApplicationIds": application_ids,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def notify(
    hub,
    ctx,
    application_id: str,
    status: str,
    update_date_time: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the migration state of an application. For a given application identified by the value passed to ApplicationId, its status is set or updated by passing one of three values to Status: NOT_STARTED | IN_PROGRESS | COMPLETED.

    Args:
        application_id(str): The configurationId in Application Discovery Service that uniquely identifies the grouped application.
        status(str): Status of the application - Not Started, In-Progress, Complete.
        update_date_time(str, optional): The timestamp when the application state changed. Defaults to None.
        dry_run(bool, optional): Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mgh.application_state.notify(
                ctx, application_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mgh.application_state.notify application_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mgh",
        operation="notify_application_state",
        op_kwargs={
            "ApplicationId": application_id,
            "Status": status,
            "UpdateDateTime": update_date_time,
            "DryRun": dry_run,
        },
    )
