"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def meter(
    hub,
    ctx,
    product_code: str,
    timestamp: str,
    usage_dimension: str,
    usage_quantity: int = None,
    dry_run: bool = None,
    usage_allocations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID. MeterUsage is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS pod. MeterUsage can optionally include multiple usage allocations, to provide customers with usage data split into buckets by tags that you define (or allow the customer to define).

    Args:
        product_code(str): Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as the one used during the publishing of a new product.
        timestamp(str): Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to one hour in the past. Make sure the timestamp value is not before the start of the software usage.
        usage_dimension(str): It will be one of the fcp dimension name provided during the publishing of the product.
        usage_quantity(int, optional): Consumption value for the hour. Defaults to 0 if not specified. Defaults to None.
        dry_run(bool, optional): Checks whether you have the permissions required for the action, but does not make the request. If you have the permissions, the request returns DryRunOperation; otherwise, it returns UnauthorizedException. Defaults to false if not specified. Defaults to None.
        usage_allocations(List, optional): The set of UsageAllocations to submit. The sum of all UsageAllocation quantities must equal the UsageQuantity of the MeterUsage request, and each UsageAllocation must have a unique set of tags (include no tags). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.meteringmarketplace.usage.meter(
                ctx, product_code=value, timestamp=value, usage_dimension=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.meteringmarketplace.usage.meter product_code=value, timestamp=value, usage_dimension=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="meteringmarketplace",
        operation="meter_usage",
        op_kwargs={
            "ProductCode": product_code,
            "Timestamp": timestamp,
            "UsageDimension": usage_dimension,
            "UsageQuantity": usage_quantity,
            "DryRun": dry_run,
            "UsageAllocations": usage_allocations,
        },
    )


async def register(
    hub, ctx, product_code: str, public_key_version: int, nonce: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the RegisterUsage operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call RegisterUsage, but you may choose to do so if you would like to receive usage data in your seller reports. The sections below explain the behavior of RegisterUsage. RegisterUsage performs two primary functions: metering and entitlement.    Entitlement: RegisterUsage allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that integrates with RegisterUsage is only required to guard against unauthorized use at container startup, as such a CustomerNotSubscribedException/PlatformNotSupportedException will only be thrown on the initial call to RegisterUsage. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not throw a CustomerNotSubscribedException, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS pod is still running.    Metering: RegisterUsage meters software use per ECS task, per hour, or per pod for Amazon EKS with usage prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate). Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software is not required to perform any metering specific actions, other than call RegisterUsage once for metering of software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your software to perform entitlement checks at runtime.

    Args:
        product_code(str): Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as the one used during the publishing of a new product.
        public_key_version(int): Public Key Version provided by AWS Marketplace.
        nonce(str, optional): (Optional) To scope down the registration to a specific running software instance and guard against replay attacks. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.meteringmarketplace.usage.register(
                ctx, product_code=value, public_key_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.meteringmarketplace.usage.register product_code=value, public_key_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="meteringmarketplace",
        operation="register_usage",
        op_kwargs={
            "ProductCode": product_code,
            "PublicKeyVersion": public_key_version,
            "Nonce": nonce,
        },
    )
