"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, usage_records: List, product_code: str) -> Dict:
    r"""
    **Autogenerated function**

    BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers. For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the input records. Every request to BatchMeterUsage is for one product. If you need to meter usage for multiple products, you must make multiple calls to BatchMeterUsage. BatchMeterUsage can process up to 25 UsageRecords at a time. A UsageRecord can optionally include multiple usage allocations, to provide customers with usagedata split into buckets by tags that you define (or allow the customer to define). BatchMeterUsage requests must be less than 1MB in size.

    Args:
        usage_records(List): The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at a time.
        product_code(str): Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as the one used during the publishing of a new product.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.meteringmarketplace.meter_usage.batch(
                ctx, usage_records=value, product_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.meteringmarketplace.meter_usage.batch usage_records=value, product_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="meteringmarketplace",
        operation="batch_meter_usage",
        op_kwargs={"UsageRecords": usage_records, "ProductCode": product_code},
    )
