"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def resolve(hub, ctx, registration_token: str) -> Dict:
    r"""
    **Autogenerated function**

    ResolveCustomer is called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a registration token through their browser. The registration token is resolved through this API to obtain a CustomerIdentifier and product code.

    Args:
        registration_token(str): When a buyer visits your website during the registration process, the buyer submits a registration token through the browser. The registration token is resolved to obtain a CustomerIdentifier and product code.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.meteringmarketplace.customer.resolve(
                ctx, registration_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.meteringmarketplace.customer.resolve registration_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="meteringmarketplace",
        operation="resolve_customer",
        op_kwargs={"RegistrationToken": registration_token},
    )
