"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    http_package_configurations: List,
    source_location_name: str,
    vod_source_name: str,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates name for a specific VOD source in a source location.

    Args:
        http_package_configurations(List): An array of HTTP package configuration parameters for this VOD source.
        source_location_name(str): The identifier for the source location you are working on.
        tags(Dict, optional): The tags to assign to the VOD source. Defaults to None.
        vod_source_name(str): The identifier for the VOD source you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.vod_source.create(
                ctx,
                http_package_configurations=value,
                source_location_name=value,
                vod_source_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.vod_source.create http_package_configurations=value, source_location_name=value, vod_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="create_vod_source",
        op_kwargs={
            "HttpPackageConfigurations": http_package_configurations,
            "SourceLocationName": source_location_name,
            "Tags": tags,
            "VodSourceName": vod_source_name,
        },
    )


async def delete(hub, ctx, source_location_name: str, vod_source_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific VOD source in a specific source location.

    Args:
        source_location_name(str): The identifier for the source location you are working on.
        vod_source_name(str): The identifier for the VOD source you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.vod_source.delete(
                ctx, source_location_name=value, vod_source_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.vod_source.delete source_location_name=value, vod_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="delete_vod_source",
        op_kwargs={
            "SourceLocationName": source_location_name,
            "VodSourceName": vod_source_name,
        },
    )


async def describe(hub, ctx, source_location_name: str, vod_source_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides details about a specific VOD source in a specific source location.

    Args:
        source_location_name(str): The identifier for the source location you are working on.
        vod_source_name(str): The identifier for the VOD source you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.vod_source.describe(
                ctx, source_location_name=value, vod_source_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.vod_source.describe source_location_name=value, vod_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="describe_vod_source",
        op_kwargs={
            "SourceLocationName": source_location_name,
            "VodSourceName": vod_source_name,
        },
    )


async def list_all(
    hub, ctx, source_location_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the VOD sources in a source location.

    Args:
        max_results(int, optional): Upper bound on number of records to return. The maximum number of results is 100. Defaults to None.
        next_token(str, optional): Pagination token from the GET list request. Use the token to fetch the next page of results. Defaults to None.
        source_location_name(str): The identifier for the source location you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.vod_source.list_all(ctx, source_location_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.vod_source.list_all source_location_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="list_vod_sources",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "SourceLocationName": source_location_name,
        },
    )


async def update(
    hub,
    ctx,
    http_package_configurations: List,
    source_location_name: str,
    vod_source_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a specific VOD source in a specific source location.

    Args:
        http_package_configurations(List): An array of HTTP package configurations for the VOD source on this account.
        source_location_name(str): The identifier for the source location you are working on.
        vod_source_name(str): The identifier for the VOD source you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.vod_source.update(
                ctx,
                http_package_configurations=value,
                source_location_name=value,
                vod_source_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.vod_source.update http_package_configurations=value, source_location_name=value, vod_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="update_vod_source",
        op_kwargs={
            "HttpPackageConfigurations": http_package_configurations,
            "SourceLocationName": source_location_name,
            "VodSourceName": vod_source_name,
        },
    )
