"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    http_configuration: Dict,
    source_location_name: str,
    access_configuration: Dict = None,
    default_segment_delivery_configuration: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a source location on a specific channel.

    Args:
        access_configuration(Dict, optional): Access configuration parameters. Configures the type of authentication used to access content from your source location. Defaults to None.
        default_segment_delivery_configuration(Dict, optional): The optional configuration for the server that serves segments. Defaults to None.
        http_configuration(Dict): The source's HTTP package configurations.
        source_location_name(str): The identifier for the source location you are working on.
        tags(Dict, optional): The tags to assign to the source location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.source_location.create(
                ctx, http_configuration=value, source_location_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.source_location.create http_configuration=value, source_location_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="create_source_location",
        op_kwargs={
            "AccessConfiguration": access_configuration,
            "DefaultSegmentDeliveryConfiguration": default_segment_delivery_configuration,
            "HttpConfiguration": http_configuration,
            "SourceLocationName": source_location_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, source_location_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a source location on a specific channel.

    Args:
        source_location_name(str): The identifier for the source location you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.source_location.delete(
                ctx, source_location_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.source_location.delete source_location_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="delete_source_location",
        op_kwargs={"SourceLocationName": source_location_name},
    )


async def describe(hub, ctx, source_location_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the properties of the requested source location.

    Args:
        source_location_name(str): The identifier for the source location you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.source_location.describe(
                ctx, source_location_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.source_location.describe source_location_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="describe_source_location",
        op_kwargs={"SourceLocationName": source_location_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of source locations.

    Args:
        max_results(int, optional): Upper bound on number of records to return. The maximum number of results is 100. Defaults to None.
        next_token(str, optional): Pagination token from the GET list request. Use the token to fetch the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.source_location.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.source_location.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="list_source_locations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    http_configuration: Dict,
    source_location_name: str,
    access_configuration: Dict = None,
    default_segment_delivery_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a source location on a specific channel.

    Args:
        access_configuration(Dict, optional): Access configuration parameters. Configures the type of authentication used to access content from your source location. Defaults to None.
        default_segment_delivery_configuration(Dict, optional): The optional configuration for the host server that serves segments. Defaults to None.
        http_configuration(Dict): The HTTP configuration for the source location.
        source_location_name(str): The identifier for the source location you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.source_location.update(
                ctx, http_configuration=value, source_location_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.source_location.update http_configuration=value, source_location_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="update_source_location",
        op_kwargs={
            "AccessConfiguration": access_configuration,
            "DefaultSegmentDeliveryConfiguration": default_segment_delivery_configuration,
            "HttpConfiguration": http_configuration,
            "SourceLocationName": source_location_name,
        },
    )
