"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Adds tags to the specified playback configuration resource. You can specify one or more tags to add.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the playback configuration. You can get this from the response to any playback configuration request.
        tags(Dict): A comma-separated list of tag key:value pairs.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes tags from the specified playback configuration resource. You can specify one or more tags to remove.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the playback configuration. You can get this from the response to any playback configuration request.
        tag_keys(List): A comma-separated list of the tag keys to remove from the playback configuration.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.resource.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
