"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    channel_name: str,
    program_name: str,
    schedule_configuration: Dict,
    source_location_name: str,
    vod_source_name: str,
    ad_breaks: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a program.

    Args:
        ad_breaks(List, optional): The ad break configuration settings. Defaults to None.
        channel_name(str): The identifier for the channel you are working on.
        program_name(str): The identifier for the program you are working on.
        schedule_configuration(Dict): The schedule configuration settings.
        source_location_name(str): The name of the source location.
        vod_source_name(str): The name that's used to refer to a VOD source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.program.create(
                ctx,
                channel_name=value,
                program_name=value,
                schedule_configuration=value,
                source_location_name=value,
                vod_source_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.program.create channel_name=value, program_name=value, schedule_configuration=value, source_location_name=value, vod_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="create_program",
        op_kwargs={
            "AdBreaks": ad_breaks,
            "ChannelName": channel_name,
            "ProgramName": program_name,
            "ScheduleConfiguration": schedule_configuration,
            "SourceLocationName": source_location_name,
            "VodSourceName": vod_source_name,
        },
    )


async def delete(hub, ctx, channel_name: str, program_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific program on a specific channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.
        program_name(str): The identifier for the program you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.program.delete(
                ctx, channel_name=value, program_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.program.delete channel_name=value, program_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="delete_program",
        op_kwargs={"ChannelName": channel_name, "ProgramName": program_name},
    )


async def describe(hub, ctx, channel_name: str, program_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the properties of the requested program.

    Args:
        channel_name(str): The identifier for the channel you are working on.
        program_name(str): The identifier for the program you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.program.describe(
                ctx, channel_name=value, program_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.program.describe channel_name=value, program_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="describe_program",
        op_kwargs={"ChannelName": channel_name, "ProgramName": program_name},
    )
