"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the playback configuration for the specified name.

    Args:
        name(str): The identifier for the playback configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.playback_configuration.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.playback_configuration.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="delete_playback_configuration",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the playback configuration for the specified name.

    Args:
        name(str): The identifier for the playback configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.playback_configuration.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.playback_configuration.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="get_playback_configuration",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the playback configurations defined in AWS Elemental MediaTailor. You can specify a maximum number of configurations to return at a time. The default maximum is 50. Results are returned in pagefuls. If MediaTailor has more configurations than the specified maximum, it provides parameters in the response that you can use to retrieve the next pageful.

    Args:
        max_results(int, optional): Maximum number of records to return. Defaults to None.
        next_token(str, optional): Pagination token returned by the GET list request when results exceed the maximum allowed. Use the token to fetch the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.playback_configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.playback_configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="list_playback_configurations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def put(
    hub,
    ctx,
    ad_decision_server_url: str = None,
    avail_suppression: Dict = None,
    bumper: Dict = None,
    cdn_configuration: Dict = None,
    configuration_aliases: Dict = None,
    dash_configuration: Dict = None,
    live_pre_roll_configuration: Dict = None,
    manifest_processing_rules: Dict = None,
    name: str = None,
    personalization_threshold_seconds: int = None,
    slate_ad_url: str = None,
    tags: Dict = None,
    transcode_profile_name: str = None,
    video_content_source_url: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new playback configuration to AWS Elemental MediaTailor.

    Args:
        ad_decision_server_url(str, optional): The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters. Defaults to None.
        avail_suppression(Dict, optional): The configuration for avail suppression, also known as ad suppression. For more information about ad suppression, see Ad Suppression. Defaults to None.
        bumper(Dict, optional): The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see Bumpers. Defaults to None.
        cdn_configuration(Dict, optional): The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management. Defaults to None.
        configuration_aliases(Dict, optional): The player parameters and aliases used as dynamic variables during session initialization. For more information, see Domain Variables. . Defaults to None.
        dash_configuration(Dict, optional): The configuration for DASH content. Defaults to None.
        live_pre_roll_configuration(Dict, optional): The configuration for pre-roll ad insertion. Defaults to None.
        manifest_processing_rules(Dict, optional): The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized manifests created by MediaTailor. Defaults to None.
        name(str, optional): The identifier for the playback configuration. Defaults to None.
        personalization_threshold_seconds(int, optional): Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to ad replacement in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see Ad Behavior in AWS Elemental MediaTailor. Defaults to None.
        slate_ad_url(str, optional): The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video. Defaults to None.
        tags(Dict, optional): The tags to assign to the playback configuration. Defaults to None.
        transcode_profile_name(str, optional): The name that is used to associate this playback configuration with a custom transcode profile. This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support. Defaults to None.
        video_content_source_url(str, optional): The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.playback_configuration.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.playback_configuration.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="put_playback_configuration",
        op_kwargs={
            "AdDecisionServerUrl": ad_decision_server_url,
            "AvailSuppression": avail_suppression,
            "Bumper": bumper,
            "CdnConfiguration": cdn_configuration,
            "ConfigurationAliases": configuration_aliases,
            "DashConfiguration": dash_configuration,
            "LivePreRollConfiguration": live_pre_roll_configuration,
            "ManifestProcessingRules": manifest_processing_rules,
            "Name": name,
            "PersonalizationThresholdSeconds": personalization_threshold_seconds,
            "SlateAdUrl": slate_ad_url,
            "Tags": tags,
            "TranscodeProfileName": transcode_profile_name,
            "VideoContentSourceUrl": video_content_source_url,
        },
    )
