"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    channel_name: str,
    duration_minutes: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about your channel's schedule.

    Args:
        channel_name(str): The identifier for the channel you are working on.
        duration_minutes(str, optional): The schedule duration in minutes. The maximum duration is 4320 minutes (three days). Defaults to None.
        max_results(int, optional): Upper bound on number of records to return. The maximum number of results is 100. Defaults to None.
        next_token(str, optional): Pagination token from the GET list request. Use the token to fetch the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.schedule.get(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.schedule.get channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="get_channel_schedule",
        op_kwargs={
            "ChannelName": channel_name,
            "DurationMinutes": duration_minutes,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
