"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a channel's IAM policy.

    Args:
        channel_name(str): The identifier for the channel you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.policy.delete(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.policy.delete channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="delete_channel_policy",
        op_kwargs={"ChannelName": channel_name},
    )


async def get(hub, ctx, channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a channel's IAM policy.

    Args:
        channel_name(str): The identifier for the channel you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.policy.get(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.policy.get channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="get_channel_policy",
        op_kwargs={"ChannelName": channel_name},
    )


async def put(hub, ctx, channel_name: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates an IAM policy for the channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.
        policy(str): Adds an IAM role that determines the permissions of your channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.policy.put(
                ctx, channel_name=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.policy.put channel_name=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="put_channel_policy",
        op_kwargs={"ChannelName": channel_name, "Policy": policy},
    )
