"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, channel_name: str, outputs: List, playback_mode: str, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.
        outputs(List): The channel's output properties.
        playback_mode(str): The type of playback mode for this channel. The only supported value is LOOP.
        tags(Dict, optional): The tags to assign to the channel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.create(
                ctx, channel_name=value, outputs=value, playback_mode=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.create channel_name=value, outputs=value, playback_mode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="create_channel",
        op_kwargs={
            "ChannelName": channel_name,
            "Outputs": outputs,
            "PlaybackMode": playback_mode,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a channel. You must stop the channel before it can be deleted.

    Args:
        channel_name(str): The identifier for the channel you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.delete(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.delete channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="delete_channel",
        op_kwargs={"ChannelName": channel_name},
    )


async def describe(hub, ctx, channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the properties of a specific channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.describe(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.describe channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="describe_channel",
        op_kwargs={"ChannelName": channel_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of channels that are associated with this account.

    Args:
        max_results(int, optional): Upper bound on number of records to return. The maximum number of results is 100. Defaults to None.
        next_token(str, optional): Pagination token from the GET list request. Use the token to fetch the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="list_channels",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def start(hub, ctx, channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a specific channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.start(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.start channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="start_channel",
        op_kwargs={"ChannelName": channel_name},
    )


async def stop(hub, ctx, channel_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a specific channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.stop(ctx, channel_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.stop channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="stop_channel",
        op_kwargs={"ChannelName": channel_name},
    )


async def update(hub, ctx, channel_name: str, outputs: List) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing channel.

    Args:
        channel_name(str): The identifier for the channel you are working on.
        outputs(List): The channel's output properties.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.channel.init.update(
                ctx, channel_name=value, outputs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.channel.init.update channel_name=value, outputs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="update_channel",
        op_kwargs={"ChannelName": channel_name, "Outputs": outputs},
    )
