"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, resource_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of alerts for the given resource.

    Args:
        max_results(int, optional): Upper bound on number of records to return. The maximum number of results is 100. Defaults to None.
        next_token(str, optional): Pagination token from the GET list request. Use the token to fetch the next page of results. Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediatailor.alert.list_all(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediatailor.alert.list_all resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediatailor",
        operation="list_alerts",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ResourceArn": resource_arn,
        },
    )
