"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "object"


async def delete(hub, ctx, path: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an object at the specified path.

    Args:
        path(str): The path (including the file name) where the object is stored in the container. Format: <folder name>/<folder name>/<file name>.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore_data.object_.delete(ctx, path=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore_data.object.delete path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore-data",
        operation="delete_object",
        op_kwargs={"Path": path},
    )


async def describe(hub, ctx, path: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the headers for an object at the specified path.

    Args:
        path(str): The path (including the file name) where the object is stored in the container. Format: <folder name>/<folder name>/<file name>.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore_data.object_.describe(ctx, path=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore_data.object.describe path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore-data",
        operation="describe_object",
        op_kwargs={"Path": path},
    )


async def get(hub, ctx, path: str, range_: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Downloads the object at the specified path. If the object’s upload availability is set to streaming, AWS Elemental MediaStore downloads the object even if it’s still uploading the object.

    Args:
        path(str): The path (including the file name) where the object is stored in the container. Format: <folder name>/<folder name>/<file name> For example, to upload the file mlaw.avi to the folder path premium\canada in the container movies, enter the path premium/canada/mlaw.avi. Do not include the container name in this path. If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an existing premium/usa subfolder. If you specify premium/canada, the service creates a canada subfolder in the premium folder. You then have two subfolders, usa and canada, in the premium folder.  There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore. For more information about folders and how they exist in a container, see the AWS Elemental MediaStore User Guide. The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension. .
        range_(str, optional): The range bytes of an object to retrieve. For more information about the Range header, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35. AWS Elemental MediaStore ignores this header for partially uploaded objects that have streaming upload availability. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore_data.object_.get(ctx, path=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore_data.object.get path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore-data",
        operation="get_object",
        op_kwargs={"Path": path, "Range": range_},
    )


async def put(
    hub,
    ctx,
    body: bytes,
    path: str,
    content_type: str = None,
    cache_control: str = None,
    storage_class: str = None,
    upload_availability: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads an object to the specified path. Object sizes are limited to 25 MB for standard upload availability and 10 MB for streaming upload availability.

    Args:
        body(bytes): The bytes to be stored. .
        path(str): The path (including the file name) where the object is stored in the container. Format: <folder name>/<folder name>/<file name> For example, to upload the file mlaw.avi to the folder path premium\canada in the container movies, enter the path premium/canada/mlaw.avi. Do not include the container name in this path. If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an existing premium/usa subfolder. If you specify premium/canada, the service creates a canada subfolder in the premium folder. You then have two subfolders, usa and canada, in the premium folder.  There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental MediaStore. For more information about folders and how they exist in a container, see the AWS Elemental MediaStore User Guide. The file name is the name that is assigned to the file that you upload. The file can have the same name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an extension. .
        content_type(str, optional): The content type of the object. Defaults to None.
        cache_control(str, optional): An optional CacheControl header that allows the caller to control the object's cache behavior. Headers can be passed in as specified in the HTTP at https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9. Headers with a custom user-defined value are also accepted. Defaults to None.
        storage_class(str, optional): Indicates the storage class of a Put request. Defaults to high-performance temporal storage class, and objects are persisted into durable storage shortly after being received. Defaults to None.
        upload_availability(str, optional): Indicates the availability of an object while it is still uploading. If the value is set to streaming, the object is available for downloading after some initial buffering but before the object is uploaded completely. If the value is set to standard, the object is available for downloading only when it is uploaded completely. The default value for this header is standard. To use this header, you must also set the HTTP Transfer-Encoding header to chunked. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore_data.object_.put(ctx, body=value, path=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore_data.object.put body=value, path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore-data",
        operation="put_object",
        op_kwargs={
            "Body": body,
            "Path": path,
            "ContentType": content_type,
            "CacheControl": cache_control,
            "StorageClass": storage_class,
            "UploadAvailability": upload_availability,
        },
    )
