"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, path: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of metadata entries about folders and objects in the specified folder.

    Args:
        path(str, optional): The path in the container from which to retrieve items. Format: <folder name>/<folder name>/<file name>. Defaults to None.
        max_results(int, optional): The maximum number of results to return per API request. For example, you submit a ListItems request with MaxResults set at 500. Although 2,000 items match your request, the service returns no more than the first 500 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 1,000 results per page. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results that you want to see. For example, you submit a ListItems request with MaxResults set at 500. The service returns the first batch of results (up to 500) and a NextToken value. To see the next batch of results, you can submit the ListItems request a second time and specify the NextToken value. Tokens expire after 15 minutes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore_data.item.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore_data.item.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore-data",
        operation="list_items",
        op_kwargs={"Path": path, "MaxResults": max_results, "NextToken": next_token},
    )
