"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the tags assigned to the specified container.

    Args:
        resource(str): The Amazon Resource Name (ARN) for the container.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.tags_for_resource.list(ctx, resource=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.tags_for_resource.list resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="list_tags_for_resource",
        op_kwargs={"Resource": resource},
    )
