"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see Tagging Resources in MediaStore.

    Args:
        resource(str): The Amazon Resource Name (ARN) for the container. .
        tags(List): An array of key:value pairs that you want to add to the container. You need to specify only the tags that you want to add or update. For example, suppose a container already has two tags (customer:CompanyA and priority:High). You want to change the priority tag and also add a third tag (type:Contract). For TagResource, you specify the following tags: priority:Medium, type:Contract. The result is that your container has three tags: customer:CompanyA, priority:Medium, and type:Contract.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.resource.tag(ctx, resource=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.resource.tag resource=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="tag_resource",
        op_kwargs={"Resource": resource, "Tags": tags},
    )


async def untag(hub, ctx, resource: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from the specified container. You can specify one or more tags to remove.

    Args:
        resource(str): The Amazon Resource Name (ARN) for the container.
        tag_keys(List): A comma-separated list of keys for tags that you want to remove from the container. For example, if your container has two tags (customer:CompanyA and priority:High) and you want to remove one of the tags (priority:High), you specify the key for the tag that you want to remove (priority).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.resource.untag(ctx, resource=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.resource.untag resource=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="untag_resource",
        op_kwargs={"Resource": resource, "TagKeys": tag_keys},
    )
