"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the metric policy that is associated with the specified container. If there is no metric policy associated with the container, MediaStore doesn't send metrics to CloudWatch.

    Args:
        container_name(str): The name of the container that is associated with the metric policy that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.metric_policy.delete(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.metric_policy.delete container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="delete_metric_policy",
        op_kwargs={"ContainerName": container_name},
    )


async def get(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the metric policy for the specified container.

    Args:
        container_name(str): The name of the container that is associated with the metric policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.metric_policy.get(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.metric_policy.get container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="get_metric_policy",
        op_kwargs={"ContainerName": container_name},
    )


async def put(hub, ctx, container_name: str, metric_policy: Dict) -> Dict:
    r"""
    **Autogenerated function**

    The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.

    Args:
        container_name(str): The name of the container that you want to add the metric policy to.
        metric_policy(Dict): The metric policy that you want to associate with the container. In the policy, you must indicate whether you want MediaStore to send container-level metrics. You can also include up to five rules to define groups of objects that you want MediaStore to send object-level metrics for. If you include rules in the policy, construct each rule with both of the following:   An object group that defines which objects to include in the group. The definition can be a path or a file name, but it can't have more than 900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are acceptable.   An object group name that allows you to refer to the object group. The name can't have more than 30 characters. Valid characters are: a-z, A-Z, 0-9, and _ (underscore).  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.metric_policy.put(
                ctx, container_name=value, metric_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.metric_policy.put container_name=value, metric_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="put_metric_policy",
        op_kwargs={"ContainerName": container_name, "MetricPolicy": metric_policy},
    )
