"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.

    Args:
        container_name(str): The name of the container that holds the object lifecycle policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.lifecycle_policy.delete(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.lifecycle_policy.delete container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="delete_lifecycle_policy",
        op_kwargs={"ContainerName": container_name},
    )


async def get(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the object lifecycle policy that is assigned to a container.

    Args:
        container_name(str): The name of the container that the object lifecycle policy is assigned to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.lifecycle_policy.get(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.lifecycle_policy.get container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="get_lifecycle_policy",
        op_kwargs={"ContainerName": container_name},
    )


async def put(hub, ctx, container_name: str, lifecycle_policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take effect. For information about how to construct an object lifecycle policy, see Components of an Object Lifecycle Policy.

    Args:
        container_name(str): The name of the container that you want to assign the object lifecycle policy to.
        lifecycle_policy(str): The object lifecycle policy to apply to the container.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.lifecycle_policy.put(
                ctx, container_name=value, lifecycle_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.lifecycle_policy.put container_name=value, lifecycle_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="put_lifecycle_policy",
        op_kwargs={
            "ContainerName": container_name,
            "LifecyclePolicy": lifecycle_policy,
        },
    )
