"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container. To use this operation, you must have permission to perform the MediaStore:DeleteCorsPolicy action. The container owner has this permission by default and can grant this permission to others.

    Args:
        container_name(str): The name of the container to remove the policy from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.cors_policy.delete(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.cors_policy.delete container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="delete_cors_policy",
        op_kwargs={"ContainerName": container_name},
    )


async def get(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the cross-origin resource sharing (CORS) configuration information that is set for the container. To use this operation, you must have permission to perform the MediaStore:GetCorsPolicy action. By default, the container owner has this permission and can grant it to others.

    Args:
        container_name(str): The name of the container that the policy is assigned to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.cors_policy.get(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.cors_policy.get container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="get_cors_policy",
        op_kwargs={"ContainerName": container_name},
    )


async def put(hub, ctx, container_name: str, cors_policy: List) -> Dict:
    r"""
    **Autogenerated function**

    Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest capability. To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses the first applicable rule listed. To learn more about CORS, see Cross-Origin Resource Sharing (CORS) in AWS Elemental MediaStore.

    Args:
        container_name(str): The name of the container that you want to assign the CORS policy to.
        cors_policy(List): The CORS policy to apply to the container. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.cors_policy.put(
                ctx, container_name=value, cors_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.cors_policy.put container_name=value, cors_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="put_cors_policy",
        op_kwargs={"ContainerName": container_name, "CorsPolicy": cors_policy},
    )
