"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, container_name: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.

    Args:
        container_name(str): The name for the container. The name must be from 1 to 255 characters. Container names must be unique to your AWS account within a specific region. As an example, you could create a container named movies in every region, as long as you don’t have an existing container with that name.
        tags(List, optional): An array of key:value pairs that you define. These values can be anything that you want. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each container. For more information about tagging, including naming and usage conventions, see Tagging Resources in MediaStore. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.container.init.create(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.container.init.create container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="create_container",
        op_kwargs={"ContainerName": container_name, "Tags": tags},
    )


async def delete(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified container. Before you make a DeleteContainer request, delete any objects in the container or in any folders in the container. You can delete only empty containers.

    Args:
        container_name(str): The name of the container to delete. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.container.init.delete(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.container.init.delete container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="delete_container",
        op_kwargs={"ContainerName": container_name},
    )


async def describe(hub, ctx, container_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a container. An endpoint is a value assigned by the service when a new container is created. A container's endpoint does not change after it has been assigned. The DescribeContainer request returns a single Container object based on ContainerName. To return all Container objects that are associated with a specified AWS account, use ListContainers.

    Args:
        container_name(str, optional): The name of the container to query. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.container.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.container.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="describe_container",
        op_kwargs={"ContainerName": container_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the properties of all containers in AWS Elemental MediaStore.  You can query to receive all the containers in one response. Or you can include the MaxResults parameter to receive a limited number of containers in each response. In this case, the response includes a token. To get the next set of containers, send the command again, this time with the NextToken parameter (with the returned token as its value). The next set of responses appears, with a token if there are still more containers to receive.  See also DescribeContainer, which gets the properties of one container.

    Args:
        next_token(str, optional): Only if you used MaxResults in the first command, enter the token (which was included in the previous response) to obtain the next set of containers. This token is included in a response only if there actually are more containers to list. Defaults to None.
        max_results(int, optional): Enter the maximum number of containers in the response. Use from 1 to 255 characters. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.container.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.container.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="list_containers",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
