"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts access logging on the specified container. When you enable access logging on a container, MediaStore delivers access logs for objects stored in that container to Amazon CloudWatch Logs.

    Args:
        container_name(str): The name of the container that you want to start access logging on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.access_logging.start(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.access_logging.start container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="start_access_logging",
        op_kwargs={"ContainerName": container_name},
    )


async def stop(hub, ctx, container_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.

    Args:
        container_name(str): The name of the container that you want to stop access logging on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediastore.access_logging.stop(ctx, container_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediastore.access_logging.stop container_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediastore",
        operation="stop_access_logging",
        op_kwargs={"ContainerName": container_name},
    )
