"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    id_: str,
    authorization: Dict = None,
    egress_access_logs: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new MediaPackage VOD PackagingGroup resource.

    Args:
        authorization(Dict, optional): CDN Authorization credentials. Defaults to None.
        egress_access_logs(Dict, optional): Configure egress access logging. Defaults to None.
        id_(str): The ID of the PackagingGroup.
        tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.group.create(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.group.create id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="create_packaging_group",
        op_kwargs={
            "Authorization": authorization,
            "EgressAccessLogs": egress_access_logs,
            "Id": id_,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a MediaPackage VOD PackagingGroup resource.

    Args:
        id_(str): The ID of the MediaPackage VOD PackagingGroup resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.group.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.group.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="delete_packaging_group",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of a MediaPackage VOD PackagingGroup resource.

    Args:
        id_(str): The ID of a MediaPackage VOD PackagingGroup resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.group.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.group.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="describe_packaging_group",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of MediaPackage VOD PackagingGroup resources.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="list_packaging_groups",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, id_: str, authorization: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a specific packaging group. You can't change the id attribute or any other system-generated attributes.

    Args:
        authorization(Dict, optional): CDN Authorization credentials. Defaults to None.
        id_(str): The ID of a MediaPackage VOD PackagingGroup resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.group.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.group.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="update_packaging_group",
        op_kwargs={"Authorization": authorization, "Id": id_},
    )
