"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    id_: str,
    packaging_group_id: str,
    cmaf_package: Dict = None,
    dash_package: Dict = None,
    hls_package: Dict = None,
    mss_package: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new MediaPackage VOD PackagingConfiguration resource.

    Args:
        cmaf_package(Dict, optional): A CMAF packaging configuration. Defaults to None.
        dash_package(Dict, optional): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration. Defaults to None.
        hls_package(Dict, optional): An HTTP Live Streaming (HLS) packaging configuration. Defaults to None.
        id_(str): The ID of the PackagingConfiguration.
        mss_package(Dict, optional): A Microsoft Smooth Streaming (MSS) PackagingConfiguration. Defaults to None.
        packaging_group_id(str): The ID of a PackagingGroup.
        tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.configuration.create(
                ctx, id_=value, packaging_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.configuration.create id_=value, packaging_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="create_packaging_configuration",
        op_kwargs={
            "CmafPackage": cmaf_package,
            "DashPackage": dash_package,
            "HlsPackage": hls_package,
            "Id": id_,
            "MssPackage": mss_package,
            "PackagingGroupId": packaging_group_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a MediaPackage VOD PackagingConfiguration resource.

    Args:
        id_(str): The ID of the MediaPackage VOD PackagingConfiguration resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.configuration.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.configuration.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="delete_packaging_configuration",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of a MediaPackage VOD PackagingConfiguration resource.

    Args:
        id_(str): The ID of a MediaPackage VOD PackagingConfiguration resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.configuration.describe(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.configuration.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="describe_packaging_configuration",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    packaging_group_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of MediaPackage VOD PackagingConfiguration resources.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.
        packaging_group_id(str, optional): Returns MediaPackage VOD PackagingConfigurations associated with the specified PackagingGroup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.packaging.configuration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.packaging.configuration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="list_packaging_configurations",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "PackagingGroupId": packaging_group_id,
        },
    )
