"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def configure(hub, ctx, id_: str, egress_access_logs: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Changes the packaging group's properities to configure log subscription

    Args:
        egress_access_logs(Dict, optional): Configure egress access logging. Defaults to None.
        id_(str): The ID of a MediaPackage VOD PackagingGroup resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.logs.configure(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.logs.configure id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="configure_logs",
        op_kwargs={"EgressAccessLogs": egress_access_logs, "Id": id_},
    )
