"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    id_: str,
    packaging_group_id: str,
    source_arn: str,
    source_role_arn: str,
    resource_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new MediaPackage VOD Asset resource.

    Args:
        id_(str): The unique identifier for the Asset.
        packaging_group_id(str): The ID of the PackagingGroup for the Asset.
        resource_id(str, optional): The resource ID to include in SPEKE key requests. Defaults to None.
        source_arn(str): ARN of the source object in S3.
        source_role_arn(str): The IAM role ARN used to access the source S3 bucket.
        tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.asset.create(
                ctx, id_=value, packaging_group_id=value, source_arn=value, source_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.asset.create id_=value, packaging_group_id=value, source_arn=value, source_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="create_asset",
        op_kwargs={
            "Id": id_,
            "PackagingGroupId": packaging_group_id,
            "ResourceId": resource_id,
            "SourceArn": source_arn,
            "SourceRoleArn": source_role_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing MediaPackage VOD Asset resource.

    Args:
        id_(str): The ID of the MediaPackage VOD Asset resource to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.asset.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.asset.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="delete_asset",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of a MediaPackage VOD Asset resource.

    Args:
        id_(str): The ID of an MediaPackage VOD Asset resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.asset.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.asset.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="describe_asset",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    packaging_group_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of MediaPackage VOD Asset resources.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.
        packaging_group_id(str, optional): Returns Assets associated with the specified PackagingGroup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage_vod.asset.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage_vod.asset.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage-vod",
        operation="list_assets",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "PackagingGroupId": packaging_group_id,
        },
    )
