"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    channel_id: str,
    id_: str,
    authorization: Dict = None,
    cmaf_package: Dict = None,
    dash_package: Dict = None,
    description: str = None,
    hls_package: Dict = None,
    manifest_name: str = None,
    mss_package: Dict = None,
    origination: str = None,
    startover_window_seconds: int = None,
    tags: Dict = None,
    time_delay_seconds: int = None,
    whitelist: List = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Creates a new OriginEndpoint record.

        Args:
            authorization(Dict, optional): CDN Authorization credentials. Defaults to None.
            channel_id(str): The ID of the Channel that the OriginEndpoint will be associated with.
    This cannot be changed after the OriginEndpoint is created.
    .
            cmaf_package(Dict, optional): A Common Media Application Format (CMAF) packaging configuration. Defaults to None.
            dash_package(Dict, optional): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration. Defaults to None.
            description(str, optional): A short text description of the OriginEndpoint. Defaults to None.
            hls_package(Dict, optional): An HTTP Live Streaming (HLS) packaging configuration. Defaults to None.
            id_(str): The ID of the OriginEndpoint.  The ID must be unique within the region
    and it cannot be changed after the OriginEndpoint is created.
    .
            manifest_name(str, optional): A short string that will be used as the filename of the OriginEndpoint URL (defaults to "index"). Defaults to None.
            mss_package(Dict, optional): A Microsoft Smooth Streaming (MSS) packaging configuration. Defaults to None.
            origination(str, optional): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
    may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
    requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    . Defaults to None.
            startover_window_seconds(int, optional): Maximum duration (seconds) of content to retain for startover playback.
    If not specified, startover playback will be disabled for the OriginEndpoint.
    . Defaults to None.
            tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.
            time_delay_seconds(int, optional): Amount of delay (seconds) to enforce on the playback of live content.
    If not specified, there will be no time delay in effect for the OriginEndpoint.
    . Defaults to None.
            whitelist(List, optional): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.mediapackage.origin_endpoint.create(
                    ctx, channel_id=value, id_=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.mediapackage.origin_endpoint.create channel_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="create_origin_endpoint",
        op_kwargs={
            "Authorization": authorization,
            "ChannelId": channel_id,
            "CmafPackage": cmaf_package,
            "DashPackage": dash_package,
            "Description": description,
            "HlsPackage": hls_package,
            "Id": id_,
            "ManifestName": manifest_name,
            "MssPackage": mss_package,
            "Origination": origination,
            "StartoverWindowSeconds": startover_window_seconds,
            "Tags": tags,
            "TimeDelaySeconds": time_delay_seconds,
            "Whitelist": whitelist,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing OriginEndpoint.

    Args:
        id_(str): The ID of the OriginEndpoint to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.origin_endpoint.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.origin_endpoint.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="delete_origin_endpoint",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about an existing OriginEndpoint.

    Args:
        id_(str): The ID of the OriginEndpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.origin_endpoint.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.origin_endpoint.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="describe_origin_endpoint",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub, ctx, channel_id: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of OriginEndpoint records.

    Args:
        channel_id(str, optional): When specified, the request will return only OriginEndpoints associated with the given Channel ID. Defaults to None.
        max_results(int, optional): The upper bound on the number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.origin_endpoint.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.origin_endpoint.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="list_origin_endpoints",
        op_kwargs={
            "ChannelId": channel_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    id_: str,
    authorization: Dict = None,
    cmaf_package: Dict = None,
    dash_package: Dict = None,
    description: str = None,
    hls_package: Dict = None,
    manifest_name: str = None,
    mss_package: Dict = None,
    origination: str = None,
    startover_window_seconds: int = None,
    time_delay_seconds: int = None,
    whitelist: List = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Updates an existing OriginEndpoint.

        Args:
            authorization(Dict, optional): CDN Authorization credentials. Defaults to None.
            cmaf_package(Dict, optional): A Common Media Application Format (CMAF) packaging configuration. Defaults to None.
            dash_package(Dict, optional): A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration. Defaults to None.
            description(str, optional): A short text description of the OriginEndpoint. Defaults to None.
            hls_package(Dict, optional): An HTTP Live Streaming (HLS) packaging configuration. Defaults to None.
            id_(str): The ID of the OriginEndpoint to update.
            manifest_name(str, optional): A short string that will be appended to the end of the Endpoint URL. Defaults to None.
            mss_package(Dict, optional): A Microsoft Smooth Streaming (MSS) packaging configuration. Defaults to None.
            origination(str, optional): Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint
    may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be
    requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
    . Defaults to None.
            startover_window_seconds(int, optional): Maximum duration (in seconds) of content to retain for startover playback.
    If not specified, startover playback will be disabled for the OriginEndpoint.
    . Defaults to None.
            time_delay_seconds(int, optional): Amount of delay (in seconds) to enforce on the playback of live content.
    If not specified, there will be no time delay in effect for the OriginEndpoint.
    . Defaults to None.
            whitelist(List, optional): A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.mediapackage.origin_endpoint.update(ctx, id_=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.mediapackage.origin_endpoint.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="update_origin_endpoint",
        op_kwargs={
            "Authorization": authorization,
            "CmafPackage": cmaf_package,
            "DashPackage": dash_package,
            "Description": description,
            "HlsPackage": hls_package,
            "Id": id_,
            "ManifestName": manifest_name,
            "MssPackage": mss_package,
            "Origination": origination,
            "StartoverWindowSeconds": startover_window_seconds,
            "TimeDelaySeconds": time_delay_seconds,
            "Whitelist": whitelist,
        },
    )
