"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def rotate(hub, ctx, id_: str, ingest_endpoint_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.

    Args:
        id_(str): The ID of the channel the IngestEndpoint is on.
        ingest_endpoint_id(str): The id of the IngestEndpoint whose credentials should be rotated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.ingest_endpoint_credential.rotate(
                ctx, id_=value, ingest_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.ingest_endpoint_credential.rotate id_=value, ingest_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="rotate_ingest_endpoint_credentials",
        op_kwargs={"Id": id_, "IngestEndpointId": ingest_endpoint_id},
    )
