"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    end_time: str,
    id_: str,
    origin_endpoint_id: str,
    s3_destination: Dict,
    start_time: str,
) -> Dict:
    r"""
        **Autogenerated function**

        Creates a new HarvestJob record.

        Args:
            end_time(str): The end of the time-window which will be harvested
    .
            id_(str): The ID of the HarvestJob. The ID must be unique within the region
    and it cannot be changed after the HarvestJob is submitted
    .
            origin_endpoint_id(str): The ID of the OriginEndpoint that the HarvestJob will harvest from.
    This cannot be changed after the HarvestJob is submitted.
    .
            s3_destination(Dict): Configuration parameters for where in an S3 bucket to place the harvested content
    .
            start_time(str): The start of the time-window which will be harvested
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.mediapackage.harvest_job.create(
                    ctx,
                    end_time=value,
                    id_=value,
                    origin_endpoint_id=value,
                    s3_destination=value,
                    start_time=value,
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.mediapackage.harvest_job.create end_time=value, id_=value, origin_endpoint_id=value, s3_destination=value, start_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="create_harvest_job",
        op_kwargs={
            "EndTime": end_time,
            "Id": id_,
            "OriginEndpointId": origin_endpoint_id,
            "S3Destination": s3_destination,
            "StartTime": start_time,
        },
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about an existing HarvestJob.

    Args:
        id_(str): The ID of the HarvestJob.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.harvest_job.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.harvest_job.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="describe_harvest_job",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub,
    ctx,
    include_channel_id: str = None,
    include_status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of HarvestJob records.

    Args:
        include_channel_id(str, optional): When specified, the request will return only HarvestJobs associated with the given Channel ID. Defaults to None.
        include_status(str, optional): When specified, the request will return only HarvestJobs in the given status. Defaults to None.
        max_results(int, optional): The upper bound on the number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.harvest_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.harvest_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="list_harvest_jobs",
        op_kwargs={
            "IncludeChannelId": include_channel_id,
            "IncludeStatus": include_status,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
