"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, id_: str, description: str = None, tags: Dict = None
) -> Dict:
    r"""
        **Autogenerated function**

        Creates a new Channel.

        Args:
            description(str, optional): A short text description of the Channel. Defaults to None.
            id_(str): The ID of the Channel. The ID must be unique within the region and it
    cannot be changed after a Channel is created.
    .
            tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.mediapackage.channel.init.create(ctx, id_=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.mediapackage.channel.init.create id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="create_channel",
        op_kwargs={"Description": description, "Id": id_, "Tags": tags},
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing Channel.

    Args:
        id_(str): The ID of the Channel to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.channel.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.channel.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="delete_channel",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about a Channel.

    Args:
        id_(str): The ID of a Channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.channel.init.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.channel.init.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="describe_channel",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of Channels.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.channel.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.channel.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="list_channels",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, id_: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Channel.

    Args:
        description(str, optional): A short text description of the Channel. Defaults to None.
        id_(str): The ID of the Channel to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediapackage.channel.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediapackage.channel.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediapackage",
        operation="update_channel",
        op_kwargs={"Description": description, "Id": id_},
    )
