"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def batch(
    hub, ctx, channel_id: str, creates: Dict = None, deletes: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Update a channel schedule

    Args:
        channel_id(str): Id of the channel whose schedule is being updated.
        creates(Dict, optional): Schedule actions to create in the schedule. Defaults to None.
        deletes(Dict, optional): Schedule actions to delete from the schedule. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.update_schedule.batch(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.update_schedule.batch channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="batch_update_schedule",
        op_kwargs={"ChannelId": channel_id, "Creates": creates, "Deletes": deletes},
    )
