"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, resource_arn: str, tags: Dict = None) -> None:
    r"""
    **Autogenerated function**

    Create tags for a resource

    Args:
        resource_arn(str): Placeholder documentation for __string.
        tags(Dict, optional): Placeholder documentation for Tags. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.tags.init.create(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.tags.init.create resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="create_tags",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def delete(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes tags for a resource

    Args:
        resource_arn(str): Placeholder documentation for __string.
        tag_keys(List): An array of tag keys to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.tags.init.delete(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.tags.init.delete resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_tags",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
