"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete all schedule actions on a channel.

    Args:
        channel_id(str): Id of the channel whose schedule is being deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.schedule.delete(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.schedule.delete channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_schedule",
        op_kwargs={"ChannelId": channel_id},
    )


async def describe(
    hub, ctx, channel_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Get a channel schedule

    Args:
        channel_id(str): Id of the channel whose schedule is being updated.
        max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
        next_token(str, optional): Placeholder documentation for __string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.schedule.describe(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.schedule.describe channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_schedule",
        op_kwargs={
            "ChannelId": channel_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
