"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, reservation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an expired reservation.

    Args:
        reservation_id(str): Unique reservation ID, e.g. '1234567'.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.reservation.delete(ctx, reservation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.reservation.delete reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_reservation",
        op_kwargs={"ReservationId": reservation_id},
    )


async def describe(hub, ctx, reservation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get details for a reservation.

    Args:
        reservation_id(str): Unique reservation ID, e.g. '1234567'.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.reservation.describe(ctx, reservation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.reservation.describe reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_reservation",
        op_kwargs={"ReservationId": reservation_id},
    )


async def list_all(
    hub,
    ctx,
    channel_class: str = None,
    codec: str = None,
    max_results: int = None,
    maximum_bitrate: str = None,
    maximum_framerate: str = None,
    next_token: str = None,
    resolution: str = None,
    resource_type: str = None,
    special_feature: str = None,
    video_quality: str = None,
) -> Dict:
    r"""
        **Autogenerated function**

        List purchased reservations.

        Args:
            channel_class(str, optional): Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
    . Defaults to None.
            codec(str, optional): Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'. Defaults to None.
            max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
            maximum_bitrate(str, optional): Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
    . Defaults to None.
            maximum_framerate(str, optional): Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'. Defaults to None.
            next_token(str, optional): Placeholder documentation for __string. Defaults to None.
            resolution(str, optional): Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'. Defaults to None.
            resource_type(str, optional): Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'. Defaults to None.
            special_feature(str, optional): Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
    . Defaults to None.
            video_quality(str, optional): Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.reservation.list_all(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.reservation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_reservations",
        op_kwargs={
            "ChannelClass": channel_class,
            "Codec": codec,
            "MaxResults": max_results,
            "MaximumBitrate": maximum_bitrate,
            "MaximumFramerate": maximum_framerate,
            "NextToken": next_token,
            "Resolution": resolution,
            "ResourceType": resource_type,
            "SpecialFeature": special_feature,
            "VideoQuality": video_quality,
        },
    )


async def update(hub, ctx, reservation_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Update reservation.

    Args:
        name(str, optional): Name of the reservation. Defaults to None.
        reservation_id(str): Unique reservation ID, e.g. '1234567'.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.reservation.update(ctx, reservation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.reservation.update reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_reservation",
        op_kwargs={"Name": name, "ReservationId": reservation_id},
    )
