"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "partner_input"


async def create(
    hub, ctx, input_id: str, request_id: str = None, tags: Dict = None
) -> Dict:
    r"""
        **Autogenerated function**

        Create a partner input

        Args:
            input_id(str): Unique ID of the input.
            request_id(str, optional): Unique identifier of the request to ensure the request is handled
    exactly once in case of retries.
    . Defaults to None.
            tags(Dict, optional): A collection of key-value pairs. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.partner_input_.create(ctx, input_id=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.partner_input.create input_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="create_partner_input",
        op_kwargs={"InputId": input_id, "RequestId": request_id, "Tags": tags},
    )
