"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, offering_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get details for an offering.

    Args:
        offering_id(str): Unique offering ID, e.g. '87654321'.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.offering.describe(ctx, offering_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.offering.describe offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_offering",
        op_kwargs={"OfferingId": offering_id},
    )


async def list_all(
    hub,
    ctx,
    channel_class: str = None,
    channel_configuration: str = None,
    codec: str = None,
    duration: str = None,
    max_results: int = None,
    maximum_bitrate: str = None,
    maximum_framerate: str = None,
    next_token: str = None,
    resolution: str = None,
    resource_type: str = None,
    special_feature: str = None,
    video_quality: str = None,
) -> Dict:
    r"""
        **Autogenerated function**

        List offerings available for purchase.

        Args:
            channel_class(str, optional): Filter by channel class, 'STANDARD' or 'SINGLE_PIPELINE'
    . Defaults to None.
            channel_configuration(str, optional): Filter to offerings that match the configuration of an existing channel, e.g. '2345678' (a channel ID)
    . Defaults to None.
            codec(str, optional): Filter by codec, 'AVC', 'HEVC', 'MPEG2', 'AUDIO', or 'LINK'. Defaults to None.
            duration(str, optional): Filter by offering duration, e.g. '12'. Defaults to None.
            max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
            maximum_bitrate(str, optional): Filter by bitrate, 'MAX_10_MBPS', 'MAX_20_MBPS', or 'MAX_50_MBPS'
    . Defaults to None.
            maximum_framerate(str, optional): Filter by framerate, 'MAX_30_FPS' or 'MAX_60_FPS'. Defaults to None.
            next_token(str, optional): Placeholder documentation for __string. Defaults to None.
            resolution(str, optional): Filter by resolution, 'SD', 'HD', 'FHD', or 'UHD'. Defaults to None.
            resource_type(str, optional): Filter by resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'. Defaults to None.
            special_feature(str, optional): Filter by special feature, 'ADVANCED_AUDIO' or 'AUDIO_NORMALIZATION'
    . Defaults to None.
            video_quality(str, optional): Filter by video quality, 'STANDARD', 'ENHANCED', or 'PREMIUM'
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.offering.list_all(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.offering.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_offerings",
        op_kwargs={
            "ChannelClass": channel_class,
            "ChannelConfiguration": channel_configuration,
            "Codec": codec,
            "Duration": duration,
            "MaxResults": max_results,
            "MaximumBitrate": maximum_bitrate,
            "MaximumFramerate": maximum_framerate,
            "NextToken": next_token,
            "Resolution": resolution,
            "ResourceType": resource_type,
            "SpecialFeature": special_feature,
            "VideoQuality": video_quality,
        },
    )


async def purchase(
    hub,
    ctx,
    count: int,
    offering_id: str,
    name: str = None,
    request_id: str = None,
    start: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Purchase an offering and create a reservation.

    Args:
        count(int): Number of resources.
        name(str, optional): Name for the new reservation. Defaults to None.
        offering_id(str): Offering to purchase, e.g. '87654321'.
        request_id(str, optional): Unique request ID to be specified. This is needed to prevent retries from creating multiple resources. Defaults to None.
        start(str, optional): Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now. Defaults to None.
        tags(Dict, optional): A collection of key-value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.offering.purchase(ctx, count=value, offering_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.offering.purchase count=value, offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="purchase_offering",
        op_kwargs={
            "Count": count,
            "Name": name,
            "OfferingId": offering_id,
            "RequestId": request_id,
            "Start": start,
            "Tags": tags,
        },
    )
