"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    multiplex_id: str,
    multiplex_program_settings: Dict,
    program_name: str,
    request_id: str,
) -> Dict:
    r"""
        **Autogenerated function**

        Create a new program in the multiplex.

        Args:
            multiplex_id(str): ID of the multiplex where the program is to be created.
            multiplex_program_settings(Dict): The settings for this multiplex program.
            program_name(str): Name of multiplex program.
            request_id(str): Unique request ID. This prevents retries from creating multiple
    resources.
    .

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.multiplex.program.create(
                    ctx,
                    multiplex_id=value,
                    multiplex_program_settings=value,
                    program_name=value,
                    request_id=value,
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.multiplex.program.create multiplex_id=value, multiplex_program_settings=value, program_name=value, request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="create_multiplex_program",
        op_kwargs={
            "MultiplexId": multiplex_id,
            "MultiplexProgramSettings": multiplex_program_settings,
            "ProgramName": program_name,
            "RequestId": request_id,
        },
    )


async def delete(hub, ctx, multiplex_id: str, program_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a program from a multiplex.

    Args:
        multiplex_id(str): The ID of the multiplex that the program belongs to.
        program_name(str): The multiplex program name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.program.delete(
                ctx, multiplex_id=value, program_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.program.delete multiplex_id=value, program_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_multiplex_program",
        op_kwargs={"MultiplexId": multiplex_id, "ProgramName": program_name},
    )


async def describe(hub, ctx, multiplex_id: str, program_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the details for a program in a multiplex.

    Args:
        multiplex_id(str): The ID of the multiplex that the program belongs to.
        program_name(str): The name of the program.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.program.describe(
                ctx, multiplex_id=value, program_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.program.describe multiplex_id=value, program_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_multiplex_program",
        op_kwargs={"MultiplexId": multiplex_id, "ProgramName": program_name},
    )


async def list_all(
    hub, ctx, multiplex_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the programs that currently exist for a specific multiplex.

    Args:
        max_results(int, optional): The maximum number of items to return. Defaults to None.
        multiplex_id(str): The ID of the multiplex that the programs belong to.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.program.list_all(ctx, multiplex_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.program.list_all multiplex_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_multiplex_programs",
        op_kwargs={
            "MaxResults": max_results,
            "MultiplexId": multiplex_id,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    multiplex_id: str,
    program_name: str,
    multiplex_program_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a program in a multiplex.

    Args:
        multiplex_id(str): The ID of the multiplex of the program to update.
        multiplex_program_settings(Dict, optional): The new settings for a multiplex program. Defaults to None.
        program_name(str): The name of the program to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.program.update(
                ctx, multiplex_id=value, program_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.program.update multiplex_id=value, program_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_multiplex_program",
        op_kwargs={
            "MultiplexId": multiplex_id,
            "MultiplexProgramSettings": multiplex_program_settings,
            "ProgramName": program_name,
        },
    )
