"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    availability_zones: List,
    multiplex_settings: Dict,
    name: str,
    request_id: str,
    tags: Dict = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Create a new multiplex.

        Args:
            availability_zones(List): A list of availability zones for the multiplex. You must specify exactly two.
            multiplex_settings(Dict): Configuration for a multiplex event.
            name(str): Name of multiplex.
            request_id(str): Unique request ID. This prevents retries from creating multiple
    resources.
    .
            tags(Dict, optional): A collection of key-value pairs. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.multiplex.init.create(
                    ctx,
                    availability_zones=value,
                    multiplex_settings=value,
                    name=value,
                    request_id=value,
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.multiplex.init.create availability_zones=value, multiplex_settings=value, name=value, request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="create_multiplex",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "MultiplexSettings": multiplex_settings,
            "Name": name,
            "RequestId": request_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, multiplex_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a multiplex. The multiplex must be idle.

    Args:
        multiplex_id(str): The ID of the multiplex.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.init.delete(ctx, multiplex_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.init.delete multiplex_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_multiplex",
        op_kwargs={"MultiplexId": multiplex_id},
    )


async def describe(hub, ctx, multiplex_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about a multiplex.

    Args:
        multiplex_id(str): The ID of the multiplex.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.init.describe(ctx, multiplex_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.init.describe multiplex_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_multiplex",
        op_kwargs={"MultiplexId": multiplex_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a list of the existing multiplexes.

    Args:
        max_results(int, optional): The maximum number of items to return. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_multiplexes",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def start(hub, ctx, multiplex_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each channel.

    Args:
        multiplex_id(str): The ID of the multiplex.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.init.start(ctx, multiplex_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.init.start multiplex_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="start_multiplex",
        op_kwargs={"MultiplexId": multiplex_id},
    )


async def stop(hub, ctx, multiplex_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a running multiplex. If the multiplex isn't running, this action has no effect.

    Args:
        multiplex_id(str): The ID of the multiplex.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.init.stop(ctx, multiplex_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.init.stop multiplex_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="stop_multiplex",
        op_kwargs={"MultiplexId": multiplex_id},
    )


async def update(
    hub, ctx, multiplex_id: str, multiplex_settings: Dict = None, name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a multiplex.

    Args:
        multiplex_id(str): ID of the multiplex to update.
        multiplex_settings(Dict, optional): The new settings for a multiplex. Defaults to None.
        name(str, optional): Name of the multiplex. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.multiplex.init.update(ctx, multiplex_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.multiplex.init.update multiplex_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_multiplex",
        op_kwargs={
            "MultiplexId": multiplex_id,
            "MultiplexSettings": multiplex_settings,
            "Name": name,
        },
    )
