"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__sub_alias__ = ["input_", "input"]


async def create(
    hub,
    ctx,
    destinations: List = None,
    input_devices: List = None,
    input_security_groups: List = None,
    media_connect_flows: List = None,
    name: str = None,
    request_id: str = None,
    role_arn: str = None,
    sources: List = None,
    tags: Dict = None,
    type_: str = None,
    vpc: Dict = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Create an input

        Args:
            destinations(List, optional): Destination settings for PUSH type inputs. Defaults to None.
            input_devices(List, optional): Settings for the devices. Defaults to None.
            input_security_groups(List, optional): A list of security groups referenced by IDs to attach to the input. Defaults to None.
            media_connect_flows(List, optional): A list of the MediaConnect Flows that you want to use in this input. You can specify as few as one
    Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a
    separate Availability Zone as this ensures your EML input is redundant to AZ issues.
    . Defaults to None.
            name(str, optional): Name of the input. Defaults to None.
            request_id(str, optional): Unique identifier of the request to ensure the request is handled
    exactly once in case of retries.
    . Defaults to None.
            role_arn(str, optional): The Amazon Resource Name (ARN) of the role this input assumes during and after creation. Defaults to None.
            sources(List, optional): The source URLs for a PULL-type input. Every PULL type input needs
    exactly two source URLs for redundancy.
    Only specify sources for PULL type Inputs. Leave Destinations empty.
    . Defaults to None.
            tags(Dict, optional): A collection of key-value pairs. Defaults to None.
            type_(str, optional): Placeholder documentation for InputType. Defaults to None.
            vpc(Dict, optional): Settings for a private VPC Input.
    When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses.
    This property requires setting the roleArn property on Input creation.
    Not compatible with the inputSecurityGroups property.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.input_.init.create(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.input_.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="create_input",
        op_kwargs={
            "Destinations": destinations,
            "InputDevices": input_devices,
            "InputSecurityGroups": input_security_groups,
            "MediaConnectFlows": media_connect_flows,
            "Name": name,
            "RequestId": request_id,
            "RoleArn": role_arn,
            "Sources": sources,
            "Tags": tags,
            "Type": type_,
            "Vpc": vpc,
        },
    )


async def delete(hub, ctx, input_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the input end point

    Args:
        input_id(str): Unique ID of the input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.init.delete(ctx, input_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.init.delete input_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_input",
        op_kwargs={"InputId": input_id},
    )


async def describe(hub, ctx, input_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Produces details about an input

    Args:
        input_id(str): Unique ID of the input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.init.describe(ctx, input_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.init.describe input_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_input",
        op_kwargs={"InputId": input_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Produces list of inputs that have been created

    Args:
        max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
        next_token(str, optional): Placeholder documentation for __string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_inputs",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    input_id: str,
    destinations: List = None,
    input_devices: List = None,
    input_security_groups: List = None,
    media_connect_flows: List = None,
    name: str = None,
    role_arn: str = None,
    sources: List = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Updates an input.

        Args:
            destinations(List, optional): Destination settings for PUSH type inputs. Defaults to None.
            input_devices(List, optional): Settings for the devices. Defaults to None.
            input_id(str): Unique ID of the input.
            input_security_groups(List, optional): A list of security groups referenced by IDs to attach to the input. Defaults to None.
            media_connect_flows(List, optional): A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as one
    Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in a
    separate Availability Zone as this ensures your EML input is redundant to AZ issues.
    . Defaults to None.
            name(str, optional): Name of the input. Defaults to None.
            role_arn(str, optional): The Amazon Resource Name (ARN) of the role this input assumes during and after creation. Defaults to None.
            sources(List, optional): The source URLs for a PULL-type input. Every PULL type input needs
    exactly two source URLs for redundancy.
    Only specify sources for PULL type Inputs. Leave Destinations empty.
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.input_.init.update(ctx, input_id=value)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.input_.init.update input_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_input",
        op_kwargs={
            "Destinations": destinations,
            "InputDevices": input_devices,
            "InputId": input_id,
            "InputSecurityGroups": input_security_groups,
            "MediaConnectFlows": media_connect_flows,
            "Name": name,
            "RoleArn": role_arn,
            "Sources": sources,
        },
    )
