"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(hub, ctx, input_device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.

    Args:
        input_device_id(str): The unique ID of the input device to accept. For example, hd-123456789abcdef.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.transfer.accept(
                ctx, input_device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.transfer.accept input_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="accept_input_device_transfer",
        op_kwargs={"InputDeviceId": input_device_id},
    )


async def cancel(hub, ctx, input_device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancel an input device transfer that you have requested.

    Args:
        input_device_id(str): The unique ID of the input device to cancel. For example, hd-123456789abcdef.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.transfer.cancel(
                ctx, input_device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.transfer.cancel input_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="cancel_input_device_transfer",
        op_kwargs={"InputDeviceId": input_device_id},
    )


async def list_all(
    hub, ctx, transfer_type: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List input devices that are currently being transferred. List input devices that you are transferring from your AWS account or input devices that another AWS account is transferring to you.

    Args:
        max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
        next_token(str, optional): Placeholder documentation for __string. Defaults to None.
        transfer_type(str): Placeholder documentation for __string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.transfer.list_all(
                ctx, transfer_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.transfer.list_all transfer_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_input_device_transfers",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "TransferType": transfer_type,
        },
    )


async def reject(hub, ctx, input_device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Reject the transfer of the specified input device to your AWS account.

    Args:
        input_device_id(str): The unique ID of the input device to reject. For example, hd-123456789abcdef.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.transfer.reject(
                ctx, input_device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.transfer.reject input_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="reject_input_device_transfer",
        op_kwargs={"InputDeviceId": input_device_id},
    )
