"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, input_device_id: str, accept: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the latest thumbnail data for the input device.

    Args:
        input_device_id(str): The unique ID of this input device. For example, hd-123456789abcdef.
        accept(str): The HTTP Accept header. Indicates the requested type for the thumbnail.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.thumbnail.describe(
                ctx, input_device_id=value, accept=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.thumbnail.describe input_device_id=value, accept=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_input_device_thumbnail",
        op_kwargs={"InputDeviceId": input_device_id, "Accept": accept},
    )
