"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, input_device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details for the input device

    Args:
        input_device_id(str): The unique ID of this input device. For example, hd-123456789abcdef.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.init.describe(
                ctx, input_device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.init.describe input_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_input_device",
        op_kwargs={"InputDeviceId": input_device_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List input devices

    Args:
        max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
        next_token(str, optional): Placeholder documentation for __string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_input_devices",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def transfer(
    hub,
    ctx,
    input_device_id: str,
    target_customer_id: str = None,
    target_region: str = None,
    transfer_message: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Start an input device transfer to another AWS account. After you make the request, the other account must accept or reject the transfer.

    Args:
        input_device_id(str): The unique ID of this input device. For example, hd-123456789abcdef.
        target_customer_id(str, optional): The AWS account ID (12 digits) for the recipient of the device transfer. Defaults to None.
        target_region(str, optional): The target AWS region to transfer the device. Defaults to None.
        transfer_message(str, optional): An optional message for the recipient. Maximum 280 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.init.transfer(
                ctx, input_device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.init.transfer input_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="transfer_input_device",
        op_kwargs={
            "InputDeviceId": input_device_id,
            "TargetCustomerId": target_customer_id,
            "TargetRegion": target_region,
            "TransferMessage": transfer_message,
        },
    )


async def update(
    hub,
    ctx,
    input_device_id: str,
    hd_device_settings: Dict = None,
    name: str = None,
    uhd_device_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the parameters for the input device.

    Args:
        hd_device_settings(Dict, optional): The settings that you want to apply to the HD input device. Defaults to None.
        input_device_id(str): The unique ID of the input device. For example, hd-123456789abcdef.
        name(str, optional): The name that you assigned to this input device (not the unique ID). Defaults to None.
        uhd_device_settings(Dict, optional): The settings that you want to apply to the UHD input device. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.input_.device.init.update(ctx, input_device_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.input_.device.init.update input_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_input_device",
        op_kwargs={
            "HdDeviceSettings": hd_device_settings,
            "InputDeviceId": input_device_id,
            "Name": name,
            "UhdDeviceSettings": uhd_device_settings,
        },
    )
