"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cdi_input_specification: Dict = None,
    channel_class: str = None,
    destinations: List = None,
    encoder_settings: Dict = None,
    input_attachments: List = None,
    input_specification: Dict = None,
    log_level: str = None,
    name: str = None,
    request_id: str = None,
    reserved: str = None,
    role_arn: str = None,
    tags: Dict = None,
    vpc: Dict = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Creates a new channel

        Args:
            cdi_input_specification(Dict, optional): Specification of CDI inputs for this channel. Defaults to None.
            channel_class(str, optional): The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline. Defaults to None.
            destinations(List, optional): Placeholder documentation for __listOfOutputDestination. Defaults to None.
            encoder_settings(Dict, optional): Encoder Settings. Defaults to None.
            input_attachments(List, optional): List of input attachments for channel. Defaults to None.
            input_specification(Dict, optional): Specification of network and file inputs for this channel. Defaults to None.
            log_level(str, optional): The log level to write to CloudWatch Logs. Defaults to None.
            name(str, optional): Name of channel. Defaults to None.
            request_id(str, optional): Unique request ID to be specified. This is needed to prevent retries from
    creating multiple resources.
    . Defaults to None.
            reserved(str, optional): Deprecated field that's only usable by whitelisted customers. Defaults to None.
            role_arn(str, optional): An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. Defaults to None.
            tags(Dict, optional): A collection of key-value pairs. Defaults to None.
            vpc(Dict, optional): Settings for VPC output. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.medialive.channel.init.create(ctx)

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.medialive.channel.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="create_channel",
        op_kwargs={
            "CdiInputSpecification": cdi_input_specification,
            "ChannelClass": channel_class,
            "Destinations": destinations,
            "EncoderSettings": encoder_settings,
            "InputAttachments": input_attachments,
            "InputSpecification": input_specification,
            "LogLevel": log_level,
            "Name": name,
            "RequestId": request_id,
            "Reserved": reserved,
            "RoleArn": role_arn,
            "Tags": tags,
            "Vpc": vpc,
        },
    )


async def delete(hub, ctx, channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts deletion of channel. The associated outputs are also deleted.

    Args:
        channel_id(str): Unique ID of the channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.init.delete(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.init.delete channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="delete_channel",
        op_kwargs={"ChannelId": channel_id},
    )


async def describe(hub, ctx, channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about a channel

    Args:
        channel_id(str): channel ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.init.describe(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.init.describe channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="describe_channel",
        op_kwargs={"ChannelId": channel_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Produces list of channels that have been created

    Args:
        max_results(int, optional): Placeholder documentation for MaxResults. Defaults to None.
        next_token(str, optional): Placeholder documentation for __string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="list_channels",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def start(hub, ctx, channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts an existing channel

    Args:
        channel_id(str): A request to start a channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.init.start(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.init.start channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="start_channel",
        op_kwargs={"ChannelId": channel_id},
    )


async def stop(hub, ctx, channel_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a running channel

    Args:
        channel_id(str): A request to stop a running channel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.init.stop(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.init.stop channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="stop_channel",
        op_kwargs={"ChannelId": channel_id},
    )


async def update(
    hub,
    ctx,
    channel_id: str,
    cdi_input_specification: Dict = None,
    destinations: List = None,
    encoder_settings: Dict = None,
    input_attachments: List = None,
    input_specification: Dict = None,
    log_level: str = None,
    name: str = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a channel.

    Args:
        cdi_input_specification(Dict, optional): Specification of CDI inputs for this channel. Defaults to None.
        channel_id(str): channel ID.
        destinations(List, optional): A list of output destinations for this channel. Defaults to None.
        encoder_settings(Dict, optional): The encoder settings for this channel. Defaults to None.
        input_attachments(List, optional): Placeholder documentation for __listOfInputAttachment. Defaults to None.
        input_specification(Dict, optional): Specification of network and file inputs for this channel. Defaults to None.
        log_level(str, optional): The log level to write to CloudWatch Logs. Defaults to None.
        name(str, optional): The name of the channel. Defaults to None.
        role_arn(str, optional): An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.init.update(ctx, channel_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.init.update channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_channel",
        op_kwargs={
            "CdiInputSpecification": cdi_input_specification,
            "ChannelId": channel_id,
            "Destinations": destinations,
            "EncoderSettings": encoder_settings,
            "InputAttachments": input_attachments,
            "InputSpecification": input_specification,
            "LogLevel": log_level,
            "Name": name,
            "RoleArn": role_arn,
        },
    )
