"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "class"


async def update(
    hub, ctx, channel_class: str, channel_id: str, destinations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the class of the channel.

    Args:
        channel_class(str): The channel class that you wish to update this channel to use.
        channel_id(str): Channel Id of the channel whose class should be updated.
        destinations(List, optional): A list of output destinations for this channel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.medialive.channel.class_.update(
                ctx, channel_class=value, channel_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.medialive.channel.class.update channel_class=value, channel_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="medialive",
        operation="update_channel_class",
        op_kwargs={
            "ChannelClass": channel_class,
            "ChannelId": channel_id,
            "Destinations": destinations,
        },
    )
