"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the tags for a MediaConvert resource.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the resource that you want to list tags for. To get the ARN, send a GET request with the resource name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.tags_for_resource.list(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.tags_for_resource.list arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="list_tags_for_resource",
        op_kwargs={"Arn": arn},
    )
